@echo off
title ICEBERG - Servidor POS
color 0B

echo ==================================================
echo   ICEBERG Manillas POS - Servidor Central
echo ==================================================
echo.

:: Verificar Python
python --version >nul 2>&1
if %errorlevel% neq 0 (
    color 0C
    echo [ERROR] Python no esta instalado o no esta en PATH.
    echo Instala Python 3.11+ desde https://python.org
    echo.
    pause
    exit /b 1
)

:: Mostrar version de Python
for /f "tokens=*" %%i in ('python --version 2^>^&1') do echo [OK] %%i detectado

:: Verificar que estamos en el directorio correcto
if not exist "%~dp0main.py" (
    color 0C
    echo [ERROR] No se encontro main.py en %~dp0
    echo Asegurate de que este script esta en la carpeta server/
    echo.
    pause
    exit /b 1
)
echo [OK] main.py encontrado

:: Verificar dependencias criticas
python -c "import fastapi" >nul 2>&1
if %errorlevel% neq 0 (
    color 0E
    echo.
    echo [!] FastAPI no esta instalado. Instalando dependencias...
    pip install fastapi uvicorn sqlalchemy httpx zeroconf
    echo.
)

:: Verificar si el puerto 8000 ya esta en uso
netstat -ano | findstr ":8000.*LISTENING" >nul 2>&1
if %errorlevel% equ 0 (
    color 0E
    echo.
    echo [!] El puerto 8000 ya esta en uso.
    echo    Puede que el servidor ya este corriendo.
    echo    Abre http://localhost:8000 para verificar.
    echo.
    pause
    exit /b 1
)

echo [OK] Puerto 8000 disponible
echo.
echo --------------------------------------------------
echo   Iniciando servidor en http://localhost:8000
echo   API docs: http://localhost:8000/docs
echo   Health:   http://localhost:8000/api/health
echo.
echo   Para detener: cierra esta ventana o Ctrl+C
echo --------------------------------------------------
echo.

:: Iniciar servidor
cd /d "%~dp0"
python -m uvicorn main:app --host 0.0.0.0 --port 8000

:: Si llega aqui es que se detuvo
echo.
echo [!] Servidor detenido.
pause
