"""
Modulo de polling del estado del hardware.
Actualiza el indicador del header cada N segundos.
"""
import threading
from typing import Callable
import api

POLL_INTERVAL_MS = 5000   # 5 segundos entre checks


def start_hardware_polling(window, update_callback: Callable[[bool, bool], None]):
    """
    Inicia el loop de polling del hardware usando .after().
    `update_callback(agent_ok, programmer_ok)` se llama en el hilo principal.

    El GET al servidor es rapido (timeout 5s), pero lo hacemos en hilo
    secundario para no congelar la UI si el servidor tarda.
    """
    def _fetch():
        """Corre en hilo secundario: llama al API."""
        status = api.get_hardware_status()
        agent_ok = not status.get("error") and status.get("agent_reachable", False)
        prog_ok = status.get("programmer_connected", False)
        # Programar el callback en el hilo principal
        window.after(0, lambda: update_callback(agent_ok, prog_ok))

    def _schedule():
        """Corre en el hilo principal: lanza hilo secundario y reprograma."""
        t = threading.Thread(target=_fetch, daemon=True)
        t.start()
        window.after(POLL_INTERVAL_MS, _schedule)

    # Primer check inmediato
    _schedule()
